/*
 * Decompiled with CFR 0.152.
 */
package com.bots.ctrl;

import com.bots.aggr.Task;
import com.bots.aggr.TaskTemplate;
import com.bots.aggr.UseCase;
import com.bots.aggr.UserTask;
import com.bots.ctrl.UserSessionVO;
import com.bots.ctrl.VO;
import com.bots.http.HttpExchange;
import com.bots.service.TaskService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/task"})
public class TaskController {
    @Autowired
    private TaskService taskService;

    @RequestMapping(value={"/createtasks"})
    @ResponseBody
    public VO createTaskForUsers(long userIdFrom, long usersCount, String taskTpl, String taskInputs) {
        Object[] taskInputsArray = null;
        if (taskInputs != null) {
            String[] taskInputsStrArray = taskInputs.split("\\|");
            taskInputsArray = new Object[taskInputsStrArray.length];
            for (int i = 0; i < taskInputsStrArray.length; ++i) {
                taskInputsArray[i] = taskInputsStrArray[i];
            }
        }
        TaskTemplate taskTemplate = null;
        try {
            taskTemplate = (TaskTemplate)Class.forName(taskTpl).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (long i = 0L; i < usersCount; ++i) {
            try {
                this.taskService.createTaskForUser(taskTemplate, userIdFrom + i, taskInputsArray);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return VO.success();
    }

    @RequestMapping(value={"/starttasks"})
    @ResponseBody
    public VO startTasks(long userIdFrom, long usersCount) {
        for (long i = 0L; i < usersCount; ++i) {
            this.taskService.userStartTask(userIdFrom + i);
        }
        return VO.success();
    }

    @RequestMapping(value={"/usersession"})
    @ResponseBody
    public VO usersession(long userId, int caseIdx) {
        UseCase useCase = this.taskService.queryUseCase(userId, caseIdx);
        if (useCase == null) {
            return VO.unsuccess("usersession not found");
        }
        return VO.success(useCase.getUserSession());
    }

    @RequestMapping(value={"/usersessions"})
    @ResponseBody
    public VO usersessions(long userIdFrom, long usersCount) {
        ArrayList<UserSessionVO> userSessionVOs = new ArrayList<UserSessionVO>();
        List<UserTask> userTasks = this.taskService.queryUserTasks(userIdFrom, usersCount);
        for (UserTask userTask : userTasks) {
            Task task = userTask.getTask();
            for (UseCase useCase : task.getCases()) {
                userSessionVOs.add(new UserSessionVO(userTask, useCase));
            }
        }
        return VO.success(userSessionVOs);
    }

    @RequestMapping(value={"/clear"})
    @ResponseBody
    public VO clear() {
        this.taskService.clear();
        HttpExchange.clearStatistic();
        return VO.success();
    }

    @RequestMapping(value={"/stationsstarttasks"})
    @ResponseBody
    public VO startTasks(long userIdFrom, long usersCount, int stationsCount) {
        this.taskService.userStartTaskWithStations(userIdFrom, usersCount, stationsCount);
        return VO.success();
    }

    @RequestMapping(value={"/httpstat"})
    @ResponseBody
    public VO httpstat() {
        Map stat = this.taskService.httpStat();
        return VO.success(stat);
    }

    @RequestMapping(value={"/httpqps"})
    @ResponseBody
    public VO httpqps(long i) {
        Map stat = this.taskService.httpQps(i);
        return VO.success(stat);
    }
}

