package io.agora.avc.app.address

import android.view.LayoutInflater
import android.view.ViewGroup
import io.agora.avc.databinding.ItemMemberSelectedBinding
import io.agora.frame.base.BaseRecyclerAdapter

class MemberSelectedAdapter : BaseRecyclerAdapter<MemberNode, MemberSelectedViewHolder>() {

    override fun convert(
        holder: MemberSelectedViewHolder,
        items: MutableList<MemberNode>?,
        position: Int
    ) {
        holder.onBind(data[position]) {
            memberSelectedListener?.onItemClicked(data[position], position)
        }
    }

    override fun bindViewHolder(parent: ViewGroup, viewType: Int): MemberSelectedViewHolder {
        return MemberSelectedViewHolder(
            ItemMemberSelectedBinding.inflate(
                LayoutInflater.from(parent.context),
                parent,
                false
            )
        )
    }

    private var memberSelectedListener: OnMemberSelectedListener? = null

    fun setOnMemberSelectedListener(listener: OnMemberSelectedListener?) {
        this.memberSelectedListener = listener
    }

    interface OnMemberSelectedListener {
        fun onItemClicked(node: MemberNode, position: Int)
    }
}