package io.agora.avc.app.address

import android.os.Bundle
import androidx.recyclerview.widget.LinearLayoutManager
import io.agora.avc.R
import io.agora.avc.bo.LocalUser
import io.agora.avc.databinding.FragmentMemberSelectedBinding
import io.agora.avc.extensions.getConferenceNicknameMaybeAssistant
import io.agora.frame.base.NovelFragment

class MemberSelectedFragment :
    NovelFragment<MemberSelectedViewModel, FragmentMemberSelectedBinding>() {

    private var localUser: LocalUser? = null
    private var operationType: Int = OPERATION_INVITE
    private var dataType: Int = DATA_ORG

    private val pageAdapter by lazy {
        MemberSelectedAdapter().apply {
            setOnMemberSelectedListener(object : MemberSelectedAdapter.OnMemberSelectedListener {
                override fun onItemClicked(node: MemberNode, position: Int) {
                    mViewModel?.uncheckMember(node)
                }
            })
        }
    }

    override fun getLayoutId(): Int {
        return R.layout.fragment_member_selected
    }

    override fun allocObserver() {
        mViewModel?.localUserLiveData?.observe(this) { user ->
            localUser = user
            mBinding.watermark.setMarkText(user.getConferenceNicknameMaybeAssistant())
        }
        mViewModel?.selectedLiveData?.observe(this) { list ->
            pageAdapter.setNewData(list)
            val selected = "${list.size}"
            mBinding.actionBar.setTitle(getString(R.string.invite_chosen, selected))
        }
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        val operationType = arguments?.getInt(KEY_OPERATION_TYPE) ?: OPERATION_INVITE
        this.operationType = operationType
        val dataType = arguments?.getInt(KEY_DATA_TYPE) ?: DATA_ORG
        this.dataType = dataType
        mViewModel?.initParams(operationType, dataType)
    }

    override fun initialize(savedInstanceState: Bundle?) {
        mBinding.rvUserList.adapter = pageAdapter
        mBinding.rvUserList.layoutManager = LinearLayoutManager(context)
    }

    companion object {
        private const val TAG = "[UI][MemberSelected]"
    }

}