package io.agora.avc.app.address

import android.annotation.SuppressLint
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import io.agora.avc.R
import io.agora.avc.databinding.ItemMemberSelectedBinding
import io.agora.avc.utils.StringUtils

class MemberSelectedViewHolder constructor(val binding: ItemMemberSelectedBinding) :
    RecyclerView.ViewHolder(binding.root) {

    @SuppressLint("SetTextI18n")
    fun onBind(data: MemberNode?, onDel: () -> Unit) {
        data?.let {
            if (StringUtils.isEmpty(data.alias)) {
                binding.tvName.text = "${data.name}"
            } else {
                binding.tvName.text = "${data.name}(${data.alias})"
            }
            Glide.with(binding.root.context)
                .load(data.avatar)
                .centerCrop()
                .placeholder(R.drawable.ic_head_portrait2)
                .into(binding.ivPhoto)
            binding.ivDel.isClickable = true
            binding.ivDel.setOnClickListener {
                binding.ivDel.isClickable = false
                onDel.invoke()
            }
        }
    }

}