package io.agora.avc.app.address

import androidx.core.view.isVisible
import io.agora.avc.R
import io.agora.avc.databinding.ItemMyGroupBinding

class MyGroupViewHolder constructor(val binding: ItemMyGroupBinding) :
    androidx.recyclerview.widget.RecyclerView.ViewHolder(binding.root) {

    fun bindTo(data: AddressBookNode?) {
        binding.checkbox.isChecked = data?.isChecked ?: false
        if (data is MyGroupNode) {
            binding.ivPhoto.setImageResource(if (data.groupId == MY_GROUP_DEPT) R.drawable.ic_mine_group else R.drawable.ic_group)
            binding.ivArrow.isVisible = !data.checkable
            binding.tvName.text = data.name
        }
    }

}