package io.agora.avc.app.address

import com.bumptech.glide.Glide
import io.agora.avc.R
import io.agora.avc.databinding.ItemUserSelectedBinding

class UserSelectedViewHolder constructor(val binding: ItemUserSelectedBinding) :
    androidx.recyclerview.widget.RecyclerView.ViewHolder(binding.root) {

    fun bindTo(data: MemberNode?) {
        Glide.with(binding.root.context)
            .load(data?.avatar)
            .centerCrop()
            .placeholder(R.drawable.ic_head_portrait2)
            .into(binding.ivPhoto)
    }

}