package io.agora.avc.app.attendees

import android.os.Bundle
import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.databinding.DataBindingUtil
import androidx.recyclerview.widget.DiffUtil
import androidx.recyclerview.widget.ListAdapter
import androidx.recyclerview.widget.RecyclerView
import io.agora.avc.R
import io.agora.avc.bo.RoomMode
import io.agora.avc.bo.valoran.ARoomUser
import io.agora.avc.databinding.ItemAttendee2Binding
import io.agora.avc.databinding.ItemAttendeeBinding
import io.agora.avc.databinding.ItemAttendeeInvitingBinding

/**
 * if receive metadata no user id,but update room host
 * then user host status will not refresh
 * so when id changed,need to changed host status
 */
class AttendeesAdapter :
    ListAdapter<ARoomUser, RecyclerView.ViewHolder>(object : DiffUtil.ItemCallback<ARoomUser>() {
        override fun areItemsTheSame(oldItem: ARoomUser, newItem: ARoomUser): Boolean {
            return oldItem.areTheSame(newItem)
        }

        override fun areContentsTheSame(oldItem: ARoomUser, newItem: ARoomUser): Boolean {
            return oldItem.streamId == newItem.streamId
                    && oldItem.uid == newItem.uid
                    && oldItem.name == newItem.name
                    && oldItem.isHost == newItem.isHost
                    && oldItem.isInterrupt == newItem.isInterrupt
                    && oldItem.feature == newItem.feature
                    && oldItem.portraitId == newItem.portraitId
                    && oldItem.isThirdPartyLoggedIn == newItem.isThirdPartyLoggedIn
                    && oldItem.thirdPartyName == newItem.thirdPartyName
                    && oldItem.thirdPartyAlias == newItem.thirdPartyAlias
                    && oldItem.thirdPartyDepartment == newItem.thirdPartyDepartment
                    && oldItem.inviteBy == newItem.inviteBy
                    && oldItem.audioState == newItem.audioState
                    && oldItem.videoState == newItem.videoState
                    && oldItem.isSpeaking == newItem.isSpeaking
                    && oldItem.volume == newItem.volume
                    && oldItem.isAudioPending == newItem.isAudioPending
                    && oldItem.isVideoPending == newItem.isVideoPending
                    && oldItem.quality == newItem.quality
                    && oldItem.shareId == newItem.shareId
                    && oldItem.parentStreamId == newItem.parentStreamId
                    && oldItem.nameStartPos == newItem.nameStartPos
                    && oldItem.nameEndPos == newItem.nameEndPos
                    && oldItem.thirdPartyNameStartPos == newItem.thirdPartyNameStartPos
                    && oldItem.thirdPartyNameEndPos == newItem.thirdPartyNameEndPos
                    && oldItem.thirdPartyAliasStartPos == newItem.thirdPartyAliasStartPos
                    && oldItem.thirdPartyAliasEndPos == newItem.thirdPartyAliasEndPos
                    && oldItem.issueDumpState == newItem.issueDumpState
                    && oldItem.isCloudRecording == newItem.isCloudRecording
                    && oldItem.isAssistant == newItem.isAssistant
                    && oldItem.online == newItem.online
                    && oldItem.showMedia == newItem.showMedia
                    && oldItem.isDialing == newItem.isDialing
        }

        override fun getChangePayload(oldItem: ARoomUser, newItem: ARoomUser): Any? {
            val bundle = Bundle()

            if (oldItem.streamId != newItem.streamId
                || oldItem.uid != newItem.uid
            ) {
                bundle.putBoolean(KEY_USER, true)
            }

            if (oldItem.name != newItem.name ||
                oldItem.thirdPartyName != newItem.thirdPartyName ||
                oldItem.thirdPartyAlias != newItem.thirdPartyAlias ||
                oldItem.nameStartPos != newItem.nameStartPos ||
                oldItem.nameEndPos != newItem.nameEndPos ||
                oldItem.thirdPartyNameStartPos != newItem.thirdPartyNameStartPos ||
                oldItem.thirdPartyNameEndPos != newItem.thirdPartyNameEndPos ||
                oldItem.thirdPartyAliasStartPos != newItem.thirdPartyAliasStartPos ||
                oldItem.thirdPartyAliasEndPos != newItem.thirdPartyAliasEndPos ||
                oldItem.isAssistant != newItem.isAssistant
            ) {
                bundle.putBoolean(KEY_NAME, true)
            }

            if (oldItem.isHost != newItem.isHost) {
                bundle.putBoolean(KEY_HOST, true)
            }

            if (oldItem.feature != newItem.feature ||
                oldItem.issueDumpState != newItem.issueDumpState ||
                oldItem.isCloudRecording != newItem.isCloudRecording
            ) {
                bundle.putBoolean(KEY_FEATURE, true)
            }

            if (oldItem.isThirdPartyLoggedIn != newItem.isThirdPartyLoggedIn) {
                bundle.putBoolean(KEY_THIRD_PARTY_STATUS, true)
            }

            if (oldItem.thirdPartyDepartment != newItem.thirdPartyDepartment) {
                bundle.putBoolean(KEY_THIRD_PARTY_DEPARTMENT, true)
            }

            if (oldItem.inviteBy != newItem.inviteBy) {
                bundle.putBoolean(KEY_INVITER, true)
            }

            if (oldItem.audioState != newItem.audioState ||
                oldItem.isAudioPending != newItem.isAudioPending
            ) {
                bundle.putBoolean(KEY_AUDIO_STATUS, true)
            }

            if (oldItem.videoState != newItem.videoState ||
                oldItem.isVideoPending != newItem.isVideoPending
            ) {
                bundle.putBoolean(KEY_VIDEO_STATUS, true)
            }

            if (oldItem.isSpeaking != newItem.isSpeaking) {
                bundle.putBoolean(KEY_SPEAKING, true)
            }

            if (oldItem.volume != newItem.volume) {
                bundle.putBoolean(KEY_VOLUME, true)
            }

            if (oldItem.shareId != newItem.shareId) {
                bundle.putBoolean(KEY_SHARE_ID, true)
            }

            if (oldItem.parentStreamId != newItem.parentStreamId) {
                bundle.putBoolean(KEY_PARENT_STREAM, true)
            }

            if (oldItem.online != newItem.online
                || oldItem.showMedia != newItem.showMedia
            ) {
                bundle.putBoolean(KEY_ASSISTANT, true)
            }

            if (oldItem.isDialing != newItem.isDialing) {
                bundle.putBoolean(KEY_IS_DIALING, true)
            }

            return if (bundle.size() > 0) {
                bundle
            } else {
                null
            }
        }
    }) {

    private var roomMode: RoomMode? = null

    private var attendeeClickListener: IAttendeeClickListener? = null

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        return when (viewType) {
            VIEW_TYPE_EMPTY -> {
                EmptyViewHolder(
                    DataBindingUtil.inflate(
                        LayoutInflater.from(parent.context),
                        R.layout.item_empty_view,
                        parent,
                        false
                    )
                )
            }
            VIEW_TYPE_PRI -> {
                val attendeesViewHolder = AttendeesViewHolder(
                    ItemAttendeeBinding.inflate(
                        LayoutInflater.from(parent.context),
                        parent,
                        false
                    )
                )
                attendeesViewHolder.setIAttendeeClickListener(attendeeClickListener)
                attendeesViewHolder
            }
            VIEW_TYPE_INVITING -> {
                AttendeesInvitingViewHolder(
                    ItemAttendeeInvitingBinding.inflate(
                        LayoutInflater.from(parent.context),
                        parent,
                        false
                    )
                ).apply {
                    setIAttendeeClickListener(attendeeClickListener)
                }
            }
            else -> {
                val attendeesViewHolder = Attendees2ViewHolder(
                    ItemAttendee2Binding.inflate(
                        LayoutInflater.from(parent.context),
                        parent,
                        false
                    )
                )
                attendeesViewHolder.setIAttendeeClickListener(attendeeClickListener)
                attendeesViewHolder
            }
        }
    }

    override fun getItemViewType(position: Int): Int {
        return when {
            isEmptyPosition(position) -> {
                VIEW_TYPE_EMPTY
            }
            roomMode == RoomMode.AGORA -> {
                if (!currentList[position].isAttendee)
                    VIEW_TYPE_INVITING
                else
                    VIEW_TYPE_PRI
            }
            else -> {
                VIEW_TYPE_PUB
            }
        }
    }

    private fun isEmptyPosition(position: Int): Boolean {
        val count = super.getItemCount()
        val user = currentList[0]
        val isEmptyUser = user.streamId == -1 && user.uid == null && user.name == null
        return position == 0 && isEmptyUser && count == 1
    }

    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {
        when (holder) {
            is IAttendeesViewHolder -> {
                holder.bindUser(getItem(position))
            }
            is AttendeesInvitingViewHolder -> {
                holder.bindUser(getItem(position))
            }
        }
    }

    override fun onBindViewHolder(
        holder: RecyclerView.ViewHolder,
        position: Int,
        payloads: MutableList<Any>
    ) {
        when (holder) {
            is IAttendeesViewHolder -> {
                holder.let { _viewHolder ->
                    getItem(position)?.let { _user ->
                        _viewHolder.user = _user
                        if (payloads.isEmpty()) {
                            onBindViewHolder(holder, position)
                        } else {
                            changePieceUI(payloads, holder, _user)
                        }
                    }
                }
            }
            is AttendeesInvitingViewHolder -> {
                getItem(position)?.let { _user ->
                    holder.user = _user
                    if (payloads.isEmpty()) {
                        onBindViewHolder(holder, position)
                    } else {
                        changePieceUIInviter(payloads, holder, _user)
                    }
                }
            }
        }
    }

    private fun changePieceUI(
        payloads: MutableList<Any>,
        holder: IAttendeesViewHolder,
        user: ARoomUser,
    ) {
        val bundle = payloads[0] as Bundle
        if (bundle.get(KEY_USER) != null) {
            holder.bindUser(user)
        }
        if (bundle.get(KEY_NAME) != null) {
            holder.bindName(user)
        }
        if (bundle.get(KEY_HOST) != null) {
            holder.bindHost(user)
        }
        if (bundle.get(KEY_FEATURE) != null) {
            holder.bindFeature(user)
        }
        if (bundle.get(KEY_THIRD_PARTY_STATUS) != null) {
            holder.bindThirdPartyStatus(user)
        }
        if (bundle.get(KEY_THIRD_PARTY_DEPARTMENT) != null) {
            holder.bindThirdPartyDepartment(user)
        }
        if (bundle.get(KEY_INVITER) != null) {
            holder.bindInviter(user)
        }
        if (bundle.get(KEY_AUDIO_STATUS) != null) {
            holder.bindAudioStatus(user)
        }
        if (bundle.get(KEY_VIDEO_STATUS) != null) {
            holder.bindVideoStatus(user)
        }
        if (bundle.get(KEY_SPEAKING) != null) {
            holder.bindSpeaking(user)
        }
        if (bundle.get(KEY_VOLUME) != null) {
            holder.bindVolume(user)
        }
        if (bundle.get(KEY_SHARE_ID) != null) {
            holder.bindShareStatus(user)
        }
        if (bundle.get(KEY_ASSISTANT) != null) {
            holder.bindAssistantStatus(user)
        }
    }

    private fun changePieceUIInviter(
        payloads: MutableList<Any>,
        holder: AttendeesInvitingViewHolder,
        user: ARoomUser,
    ) {
        val bundle = payloads[0] as Bundle
        if (bundle.get(KEY_USER) != null) {
            holder.bindUser(user)
        }
        if (bundle.get(KEY_NAME) != null) {
            holder.bindName(user)
        }
        if (bundle.get(KEY_THIRD_PARTY_DEPARTMENT) != null) {
            holder.bindDepartment(user)
        }
        if (bundle.get(KEY_IS_DIALING) != null) {
            holder.bindDialing(user)
        }
    }

    fun setIAttendeeClickListener(listener: IAttendeeClickListener?) {
        this.attendeeClickListener = listener
    }

    fun setRoomModel(mode: RoomMode?) {
        if (this.roomMode != mode) {
            this.roomMode = mode
            notifyDataSetChanged()
        }
    }

    interface IAttendeeClickListener {
        fun onAttendeeClicked(user: ARoomUser)
    }

    companion object {
        const val VIEW_TYPE_PRI: Int = 100
        const val VIEW_TYPE_PUB: Int = 101
        const val VIEW_TYPE_EMPTY: Int = 102
        const val VIEW_TYPE_INVITING: Int = 103

        private const val KEY_USER: String = "key_user"
        private const val KEY_NAME: String = "key_name"
        private const val KEY_HOST: String = "key_host"
        private const val KEY_FEATURE: String = "key_feature"
        private const val KEY_PORTRAIT: String = "key_portrait"
        private const val KEY_THIRD_PARTY_STATUS: String = "key_third_party_status"
        private const val KEY_THIRD_PARTY_NAME: String = "key_third_party_name"
        private const val KEY_THIRD_PARTY_DEPARTMENT: String = "key_third_party_department"
        private const val KEY_INVITER: String = "key_inviter"
        private const val KEY_AUDIO_STATUS: String = "key_audio_status"
        private const val KEY_VIDEO_STATUS: String = "key_video_status"
        private const val KEY_SPEAKING: String = "key_speaking"
        private const val KEY_VOLUME: String = "key_volume"
        private const val KEY_QUALITY: String = "key_quality"
        private const val KEY_SHARE_ID: String = "key_share_id"
        private const val KEY_PARENT_STREAM: String = "key_parent_stream"
        private const val KEY_ASSISTANT: String = "key_assistant"
        private const val KEY_IS_DIALING: String = "key_is_dialing"
    }

}