package io.agora.avc.app.bugReport

import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.databinding.DataBindingUtil
import io.agora.avc.R
import io.agora.avc.bo.Attachment
import io.agora.frame.base.BaseRecyclerAdapter

class BugReportAdapter : BaseRecyclerAdapter<Attachment, BugReportViewHolder>() {
    private var delClickListener: OnDelClickListener? = null

    override fun convert(
        holder: BugReportViewHolder,
        items: MutableList<Attachment>?,
        position: Int
    ) {
        holder.bindTo(data[position])
    }

    override fun bindViewHolder(parent: ViewGroup, viewType: Int): BugReportViewHolder {
        return BugReportViewHolder(
            DataBindingUtil.inflate(
                LayoutInflater.from(parent.context),
                R.layout.item_bug_report,
                parent,
                false
            )
        ).apply {
            this.setOnDelClickListener(delClickListener)
        }
    }

    fun setOnDelClickListener(listener: OnDelClickListener?) {
        this.delClickListener = listener
    }

    interface OnDelClickListener {
        fun onDelClicked(attachment: Attachment)
    }
}