package io.agora.avc.app.chat

import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.databinding.DataBindingUtil
import androidx.recyclerview.widget.RecyclerView
import io.agora.avc.R
import io.agora.avc.bo.Message
import io.agora.frame.base.BaseRecyclerAdapter

class ChatAdapter : BaseRecyclerAdapter<Message, RecyclerView.ViewHolder>() {
    override fun convert(
        holder: RecyclerView.ViewHolder,
        items: MutableList<Message>?,
        position: Int
    ) {
        when (holder) {
            is ChatRightViewHolder -> {
                holder.bindTo(data[position])
            }
            is ChatLeftViewHolder -> {
                holder.bindTo(data[position])
            }
            else -> {
                if (holder is ChatUnknownViewHolder) {
                    holder.bindTo(data[position])
                }
            }
        }
    }

    override fun bindViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        val viewHolder = when (viewType) {
            Message.CHAT_LEFT -> {
                ChatLeftViewHolder(
                    DataBindingUtil.inflate(
                        LayoutInflater.from(parent.context),
                        R.layout.item_chat_left,
                        parent,
                        false
                    )
                )
            }
            Message.CHAT_RIGHT -> {
                ChatRightViewHolder(
                    DataBindingUtil.inflate(
                        LayoutInflater.from(parent.context),
                        R.layout.item_chat_right,
                        parent,
                        false
                    )
                )
            }
            else -> {
                ChatUnknownViewHolder(
                    DataBindingUtil.inflate(
                        LayoutInflater.from(parent.context),
                        R.layout.item_chat_unknown,
                        parent,
                        false
                    )
                )
            }
        }

        if (viewHolder is ChatRightViewHolder) {
            viewHolder.setItemClickListener(onItemListener)
        }

        return viewHolder
    }

    override fun getItemViewType(position: Int): Int {
        return data[position].itemViewType
    }

    private var onItemListener: OnItemListener? = null

    fun setItemClickListener(listener: OnItemListener?) {
        this.onItemListener = listener
    }

    interface OnItemListener {
        fun onClicked(id: Int)
    }

}