package io.agora.avc.app.chat

import android.app.Dialog
import android.os.Bundle
import android.text.Editable
import android.text.TextWatcher
import android.view.WindowManager
import androidx.appcompat.app.AppCompatDialog
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.lifecycle.Observer
import io.agora.avc.R
import io.agora.avc.app.master.MainViewModel
import io.agora.avc.databinding.FragmentChatInputBinding
import io.agora.avc.utils.KeyboardUtils
import io.agora.frame.base.BaseDialogFragment

class ChatInputFragment : BaseDialogFragment<ChatViewModel, FragmentChatInputBinding>() {

    private val mainViewModel: MainViewModel by lazy {
        getViewModel(requireActivity().viewModelStore, MainViewModel::class.java)
    }

    private val inputTextWatcher = object : TextWatcher {
        override fun afterTextChanged(s: Editable?) {
            if (s != null && s.isNotEmpty()) {
                if (mBinding.etInput.tag != true) {
                    mBinding.ivSend.isActivated = true
                    mBinding.etInput.isActivated = true
                    mBinding.etInput.tag = true
                }
            } else {
                if (mBinding.etInput.tag != false) {
                    mBinding.ivSend.isActivated = false
                    mBinding.etInput.isActivated = false
                    mBinding.etInput.tag = false
                }
            }
        }

        override fun beforeTextChanged(s: CharSequence?, start: Int, count: Int, after: Int) {
        }

        override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {
        }
    }

    override fun onCreateDialog(savedInstanceState: Bundle?): Dialog {
        return if (context == null) {
            super.onCreateDialog(savedInstanceState)
        } else {
            AppCompatDialog(context, R.style.FullScreenMaterialAlertDialog)
        }
    }

    override fun getLayoutId(): Int {
        return R.layout.fragment_chat_input
    }

    override fun onStart() {
        super.onStart()
        dialog?.window?.setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_VISIBLE or WindowManager.LayoutParams.SOFT_INPUT_ADJUST_RESIZE)
        onConfigurationChanged(resources.configuration)
        mBinding.etInput.requestFocus()
    }

    override fun initialize(savedInstanceState: Bundle?) {
        mBinding.etInput.addTextChangedListener(inputTextWatcher)
        mBinding.ivSend.setOnClickListener {
            mBinding.etInput.text?.toString()?.let {
                if (it.isNotEmpty()) {
                    mViewModel?.sendChatMessage(it)
                    mBinding.etInput.text?.clear()
                    onBackPressed()
                }
            }
        }
        mBinding.touchOutside.setOnClickListener {
            onBackPressed()
        }
        mainViewModel.softInputEvent.observe(this, Observer { height ->
            if (height == 0) {
                onBackPressed()
            } else {
                val layoutParams =
                    mBinding.llChatInput.layoutParams as ConstraintLayout.LayoutParams
                layoutParams.bottomMargin = height
                mBinding.llChatInput.layoutParams = layoutParams
            }
        })
    }

    override fun onDestroyView() {
        mBinding.etInput.removeTextChangedListener(inputTextWatcher)
        hideKeyboard()
        super.onDestroyView()
    }

    override fun onDestroy() {
        super.onDestroy()
    }

    private fun hideKeyboard() {
        KeyboardUtils.hideSoftInput(mBinding.etInput)
    }

}