package io.agora.avc.app.group

import android.annotation.SuppressLint
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import io.agora.avc.R
import io.agora.avc.app.address.AddressBookNode
import io.agora.avc.app.address.MemberNode
import io.agora.avc.databinding.ItemGroupTailoredMemberBinding
import io.agora.avc.utils.StringUtils

class GroupTailoredViewHolder constructor(val binding: ItemGroupTailoredMemberBinding) :
    RecyclerView.ViewHolder(binding.root) {

    @SuppressLint("SetTextI18n")
    fun onBind(data: AddressBookNode?, onDel: () -> Unit) {
        if (data is MemberNode) {
            if (StringUtils.isEmpty(data.alias)) {
                binding.tvName.text = "${data.name}"
            } else {
                binding.tvName.text = "${data.name}(${data.alias})"
            }
            Glide.with(binding.root.context)
                .load(data.avatar)
                .centerCrop()
                .placeholder(R.drawable.ic_head_portrait2)
                .into(binding.ivPhoto)
            binding.ivDel.isClickable = true
            binding.ivDel.setOnClickListener {
                binding.ivDel.isClickable = false
                onDel.invoke()
            }
        }
    }

}