package io.agora.avc.app.log

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.core.content.ContextCompat
import androidx.recyclerview.widget.DiffUtil
import androidx.recyclerview.widget.ListAdapter
import androidx.recyclerview.widget.RecyclerView
import io.agora.avc.R
import io.agora.logger.Log
import io.agora.logger.LogData

class LogAdapter(private val context: Context) :
    ListAdapter<LogData, LogAdapter.LogViewHolder>(object : DiffUtil.ItemCallback<LogData>() {
        override fun areItemsTheSame(oldItem: LogData, newItem: LogData): Boolean {
            return oldItem.type == newItem.type
        }

        override fun areContentsTheSame(oldItem: LogData, newItem: LogData): Boolean {
            return oldItem.string == newItem.string
        }

    }) {
    private val inflater: LayoutInflater = LayoutInflater.from(context)

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): LogViewHolder {
        return LogViewHolder(inflater.inflate(R.layout.item_log, parent, false))
    }

    override fun onBindViewHolder(holder: LogViewHolder, position: Int) {
        holder.renderItem(getItem(position))
    }

    inner class LogViewHolder(view: View) : RecyclerView.ViewHolder(view) {

        private val textView: TextView = view.findViewById(R.id.logText)

        fun renderItem(log: LogData) {
            textView.text = log.string

            when (log.type) {
                Log.LOG_LEVEL_ERROR -> textView.setTextColor(
                    ContextCompat.getColor(
                        context,
                        R.color.colorLogError
                    )
                )
                Log.LOG_LEVEL_WARNING -> textView.setTextColor(
                    ContextCompat.getColor(
                        context,
                        R.color.colorLogWarning
                    )
                )
                else -> textView.setTextColor(
                    ContextCompat.getColor(
                        context,
                        R.color.colorLogNormal
                    )
                )
            }
        }
    }

}