package io.agora.avc.app.mine

import android.os.Bundle
import androidx.core.os.bundleOf
import io.agora.avc.R
import io.agora.avc.app.web.KEY_URL
import io.agora.avc.app.web.getOAuthUrl
import io.agora.avc.databinding.FragmentLoginOperationBinding
import io.agora.avc.extensions.safeNavigate
import io.agora.avc.widget.COMPANY_AGORA
import io.agora.avc.widget.TYPE_COMPANY
import io.agora.frame.base.BaseSheetDialogFragment
import io.agora.frame.base.BaseViewModel

class LoginOperationFragment :
    BaseSheetDialogFragment<BaseViewModel, FragmentLoginOperationBinding>() {

    private var type = COMPANY_AGORA

    override fun getLayoutId() = R.layout.fragment_login_operation

    override fun initialize(savedInstanceState: Bundle?) {

        type = arguments?.getInt(TYPE_COMPANY) ?: COMPANY_AGORA

        mBinding.llLoginWithWeWork.setOnClickListener {
            onBackPressed()
            safeNavigate(R.id.action_global_we_work_selection)
        }
        mBinding.llLoginWithQr.setOnClickListener {
            safeNavigate(
                R.id.action_global_wework_web,
                bundleOf(TYPE_COMPANY to type)
            )
        }
        mBinding.llLoginWithEmail.setOnClickListener {
            safeNavigate(
                R.id.action_global_web,
                bundleOf(KEY_URL to getOAuthUrl())
            )
        }
    }
}