package io.agora.avc.app.splash

import android.os.Bundle
import androidx.databinding.ViewDataBinding
import androidx.navigation.fragment.NavHostFragment
import io.agora.avc.R
import io.agora.avc.extensions.safeNavigate
import io.agora.frame.base.NovelFragment

class SplashFragment : NovelFragment<SplashViewModel, ViewDataBinding>() {

    override fun getLayoutId(): Int {
        return R.layout.fragment_splash
    }

    override fun allocObserver() {

    }

    override fun initialize(savedInstanceState: Bundle?) {
        if (mViewModel?.appFirstOpened() == true) {
            NavHostFragment.findNavController(this).popBackStack()
            safeNavigate(R.id.welcome)
        } else {
            NavHostFragment.findNavController(this).popBackStack()
            safeNavigate(R.id.enter)
        }
    }

    override fun onBackPressed() {
        finish()
    }

}
