package io.agora.avc.app.splash

import android.app.Application
import io.agora.avc.base.AppViewModel
import io.agora.avc.biz.AppController
import io.agora.avc.repository.AppConfigRepository
import io.agora.logger.Logger
import javax.inject.Inject

class SplashViewModel @Inject constructor(
    application: Application,
    appController: AppController,
    private val appConfigRepository: AppConfigRepository,
) : AppViewModel(application, appController) {

    fun appFirstOpened(): Boolean {
        val alreadyOpened = appConfigRepository.getShowWelcome()
        if (!alreadyOpened) {
            Logger.i(TAG, "The app opens for the first time")
            appConfigRepository.saveShowWelcome(true)
        }
        return !alreadyOpened
    }

    companion object {
        private const val TAG = "[VM][Splash]"
    }
}