package io.agora.avc.app.web

import android.content.Context
import android.webkit.JavascriptInterface
import io.agora.avc.utils.ToastUtils
import io.agora.logger.Logger

/** Instantiate the interface and set the context  */
class WebAppInterface(private val context: Context) {

    private var response: WebAppResponse? = null

    @JavascriptInterface
    fun onWWAPILoginCallback(success: Boolean?, data: String?) {
        ToastUtils.showShort("success:$success data:$data")
    }

    @JavascriptInterface
    fun switchUrl(url: String) {
        Logger.i(TAG, "switch url:$url")
        response?.onSwitchUrl(url)
    }

    fun setWebAppResponse(response: WebAppResponse?) {
        this.response = response
    }

    interface WebAppResponse {
        fun onSwitchUrl(url: String)
    }

    companion object {
        private const val TAG = "WebAppInterface"
    }
}
