package io.agora.avc.app.web

import android.app.Application
import android.net.Uri
import android.util.Log
import io.agora.avc.auth.signin.SignInManager
import io.agora.avc.BuildConfig
import io.agora.avc.bo.UserSource
import io.agora.avc.manager.splite.SPLiteProxy
import io.agora.avc.auth.signin.wework.EASEMOB_APP_ID
import io.agora.avc.utils.DeviceUtils
import io.agora.frame.base.BaseViewModel
import io.agora.logger.Logger
import javax.inject.Inject

class WebViewModel @Inject constructor(
    application: Application,
    private val signInManager: SignInManager
) : BaseViewModel(application) {

    fun handleCallback(uri: Uri?) {
        if (handleOAuth(uri)) {
            return
        }
    }

    fun handleWeworkLogin(uri: Uri?): Boolean {
        if (BuildConfig.DEBUG) {
            Log.d(TAG, "handle wework login: uri = $uri")
        } else {
            Logger.i(TAG, "handle wework login")
        }
        val code = uri?.getQueryParameter(PARAMETER_CODE)
        val appId = uri?.getQueryParameter(PARAMETER_APP_ID)
        if (uri?.host == getLoginHost() && uri.path == getLoginPATH() && code?.isNotEmpty() == true) {
            queryInnerSession(
                code,
                if (isEasemobAppId(appId)) UserSource.EASEMOB.value else UserSource.AGORAN.value,
                DeviceUtils.getPlatform(),
                DeviceUtils.getModel()
            )
            return true
        }
        return false
    }

    private fun queryInnerSession(code: String, value: Int, platform: String, deviceName: String) {
        signInManager.queryAccountInfo(code, value, platform, deviceName)
    }

    /**
     * container email and wework(at OAuth)
     */
    private fun handleOAuth(uri: Uri?): Boolean {
        if (BuildConfig.DEBUG) {
            Log.d(TAG, "handle oauth login: uri = $uri")
        } else {
            Logger.i(TAG, "handle oauth login")
        }
        uri?.let { _uri ->
            val code = _uri.getQueryParameter(PARAMETER_CODE)
            if (_uri.toString().startsWith(getOAuthCallback()) && code?.isNotEmpty() == true) {
                queryInnerSession(
                    code,
                    UserSource.EMAIL.value,
                    DeviceUtils.getPlatform(),
                    DeviceUtils.getModel()
                )
                return true
            }
        }
        return false
    }


    private fun getLoginHost(): String {
        return if (SPLiteProxy.isTestServer()) LOGIN_HOST_DEBUG else LOGIN_HOST_RELEASE
    }

    private fun getLoginPATH(): String {
        return if (SPLiteProxy.isTestServer()) LOGIN_PATH_DEBUG else LOGIN_PATH_RELEASE
    }

    private fun isEasemobAppId(appId: String?): Boolean {
        return appId == EASEMOB_APP_ID
    }

    companion object {
        private const val TAG = "[VM][WebView]"

        private const val PARAMETER_CODE = "code"
        private const val PARAMETER_APP_ID = "appid"
        private const val LOGIN_HOST_RELEASE = "videocall.agora.io"
        private const val LOGIN_HOST_DEBUG = "avc-staging.sh.agoralab.co"
        private const val LOGIN_PATH_RELEASE = "/login"
        private const val LOGIN_PATH_DEBUG = "/avc_private_test/login"
    }
}