package io.agora.avc.auth.signin.wework

import android.content.Context
import io.agora.avc.bo.UserSource
import io.agora.avc.net.bean.BaseNo
import io.agora.avc.utils.DeviceUtils
import io.reactivex.Observable

interface WeWorkManager {

    fun initWWAPI(context: Context)

    /**
     * login via WeWork
     * request weWork sdk -> call server
     */
    fun loginViaWeWork(type: Int)

    fun requestLogin(
        source: Int = UserSource.AGORAN.value,
        platform: String = DeviceUtils.getPlatform(),
        deviceName: String = DeviceUtils.getModel(),
        type: Int
    )

    fun logoutViaWeWork()

    /**
     * verify session
     */
    fun verifySession(session: String?, source: Int)

    fun deInitWWAPI()

    fun isWWAppInstalled(): Boolean

    /**
     * developer mode login weWork
     */
    fun loginWeWorkForDeveloper(login: Boolean)

    /**
     * queryInnerSession
     * @param code
     */
    fun queryInnerSession(
        code: String,
        source: Int = UserSource.AGORAN.value,
        platform: String = DeviceUtils.getPlatform(),
        deviceName: String = DeviceUtils.getModel()
    )

    fun delInnerSession(): Observable<BaseNo>

    interface IWWAPILoginCallBackListener {
        fun onCancel()
        fun onFailure()
        fun onSuccess(code: String)
    }

}