package io.agora.avc.biz

import android.content.Context
import com.agora.valoran.IValoranEvents
import io.agora.avc.app.address.MemberNode
import io.agora.avc.biz.event.AppEvent
import io.agora.avc.biz.vlr.IVlrClient
import io.agora.avc.bo.LocalUser
import io.agora.avc.bo.Room
import io.agora.avc.bo.valoran.ARoomUser
import java.util.*

interface AppController : IVlrClient {
    override fun initialize(
        context: Context,
        eventObserver: IValoranEvents,
        isEnvProduction: Boolean,
        logPath: String,
        customType: Int
    ) {

    }

    fun initialize(context: Context, isEnvProduction: Boolean, logPath: String, customType: Int)

    /**
     * biz connected means rtm connected
     */
    fun bizConnected(): Boolean

    /**
     * room connected means rtc connected
     */
    fun roomConnected(): Boolean

    fun registerObserver(eventObserver: Observer, uiEvents: Array<AppEvent>?)

    fun unregisterObserver(eventObserver: Observer, uiEvents: Array<AppEvent>?)

    fun connectRtmLink(connect: Boolean)
    fun useMetaData(use: Boolean)
    fun useDataChannel(use: Boolean)
    fun showMediaStatics(visible: Boolean)
    fun openNetworkEvaluation(open: Boolean)
    fun setWifiAp(open: Boolean)
    fun updateLocalUser(user: ARoomUser): LocalUser?
    fun setLocalUser(user: LocalUser)
    fun acceptAssistantRequest(tag: String)
    fun refuseAssistantRequest(tag: String)
    fun acceptMediaRequest(type: Int)
    fun refuseMediaRequest(type: Int)
    fun changeRoom(newRoom: Room)
    fun handleTokenBad()
    fun getOperationSeqId(): Int
    fun addMeetupMembers(currentSeq: Int, source: ArrayList<MemberNode>)

    /**
     * @param volume [1~99]
     */
    fun setRemoteLowerVolume(volume: Int)
    fun setAudioEnable(enable: Boolean)
}