package io.agora.avc.biz.event

import java.util.*

interface AppEventBus {

    fun addObserver(observer: Observer, events: Array<AppEvent>?)

    /**
     * unbind Observer for Observable based on events
     * @param observer
     * @param events if null then delete all
     */
    fun deleteObserver(observer: Observer, events: Array<AppEvent>?)

    /**
     * notify observer base on events
     * @param data
     */
    fun notifyObservers(data: MessageEvent)
}