package io.agora.avc.biz.event

import io.agora.avc.biz.vlr.VlrEventObservable
import java.util.*
import java.util.concurrent.ConcurrentHashMap
import javax.inject.Inject

class AppEventBusImp @Inject constructor() : AppEventBus {
    private val observableStore: ConcurrentHashMap<Int, VlrEventObservable> by lazy {
        val hashMap = ConcurrentHashMap<Int, VlrEventObservable>()
        AppEvent.values().forEach { event ->
            hashMap[event.ordinal] = VlrEventObservable()
        }
        hashMap
    }

    /**
     * Monitor Observer for Observable based on events
     * @param observer
     * @param events if null then add all
     */
    override fun addObserver(observer: Observer, events: Array<AppEvent>?) {
        if (events == null) {
            observableStore.entries.forEach { entity ->
                entity.value.addObserver(observer)
            }
            return
        }
        events.forEach { event ->
            observableStore[event.ordinal]?.addObserver(observer)
        }
    }

    /**
     * unbind Observer for Observable based on events
     * @param observer
     * @param events if null then delete all
     */
    override fun deleteObserver(observer: Observer, events: Array<AppEvent>?) {
        if (events == null) {
            observableStore.entries.forEach { entity ->
                entity.value.deleteObserver(observer)
            }
            return
        }
        events.forEach { event ->
            observableStore[event.ordinal]?.deleteObserver(observer)
        }

    }

    /**
     * notify observer base on events
     * @param data
     */
    override fun notifyObservers(data: MessageEvent) {
        observableStore[data.type]?.notifyObservers(data)
    }

    companion object {
        private const val TAG = "[VM][AppEventBus]"
    }

}