package io.agora.avc.bo

import io.agora.avc.net.bean.BaseNo

data class AppConfig(
    val app: AppSetting?,
    val valoran: ValoranSetting?,
) : BaseNo()

data class AppSetting(
    val needUploadLog: Boolean = false,
    val notice: String?,
    val renderRawData: Boolean = true,
    var encryptionMode: Int?,
    val userExperiencePlan: Boolean = false,
    val enableWatermark: Boolean = false,
    val maxMeetupMembersNum: Int,
    val maxMeetupsNum: Int,
    val rtcProxy: RtcProxy,
    val enableSS: Boolean = false,
    val enableHomeBanner: Boolean = true,
)

data class RtcProxy(val domain: String, val enable: Boolean, val ips: ArrayList<String>)

data class ValoranSetting(
    val maxRequestTimeout: Int,//rtm non request message time out
    val businessTimeout: Int,//rtm biz request message time out
    val parameters: Parameter?,
    val unmuteRequestTimeout: Int,//rtm non request message time out
)

data class Parameter(
    val rtc: List<String>?,
    val rtm: List<String>?,
    val valoran: List<String>?,
)

