package io.agora.avc.bo

data class InnerInfo(
    var alias: String?,
    var department: String?,
    val name: String?,
    val innerSession: String?,
    val source: Int,
) {
    fun getNickname(): String? {
        if (alias != null && alias?.isNotEmpty() == true) {
            return "$name(${alias})"
        }
        return name
    }

    fun isAgoran(): Boolean {
        return source == UserSource.AGORAN.value
    }
}