package io.agora.avc.bo

import io.agora.avc.bo.valoran.ARoomUser
import io.agora.avc.utils.GsonUtils
import org.json.JSONObject

/**
 * Native user
 */
data class LocalUser(
    var token: String? = null,
    var thirdPartyInnerSession: String? = null,
    var recordingId: String? = null,
    var recordingTime: Long? = null
) : ARoomUser() {

    fun copy(): LocalUser {
        val user = LocalUser()
        user.streamId = this.streamId
        user.name = this.name
        user.source = this.source

        //local user
        user.token = this.token
        user.thirdPartyInnerSession = this.thirdPartyInnerSession
        user.recordingId = this.recordingId
        user.recordingTime = this.recordingTime

        // Biz User Info=this.streamId,
        user.uid = this.uid
        user.isHost = this.isHost
        user.isInterrupt = this.isInterrupt
        user.isCloudRecording = this.isCloudRecording
        user.issueDumpState = this.issueDumpState
        user.feature = this.feature
        user.portraitId = this.portraitId
        user.avatar = this.avatar
        user.isThirdPartyLoggedIn = this.isThirdPartyLoggedIn
        user.thirdPartyName = this.thirdPartyName
        user.thirdPartyUid = this.thirdPartyUid
        user.thirdPartyAlias = this.thirdPartyAlias
        user.thirdPartyDepartment = this.thirdPartyDepartment
        user.inviteBy = this.inviteBy
        user.isAssistant = this.isAssistant
        user.online = this.online
        user.isAttendee = this.isAttendee
        user.isDialing = this.isDialing

        // Media User Info=this.streamId,
        user.audioState = this.audioState
        user.isAudioPending = this.isAudioPending
        user.isVideoPending = this.isVideoPending
        user.videoState = this.videoState
        user.isSpeaking = this.isSpeaking
        user.quality = this.quality
        user.shareId = this.shareId
        user.parentStreamId = this.parentStreamId
        user.hasWatermark = this.hasWatermark

        //stats
        user.volume = this.volume
        user.width = this.width
        user.height = this.height
        user.fps = this.fps
        user.bitrate = this.bitrate
        user.streamType = this.streamType
        user.rotation = this.rotation
        return user
    }

    /**
     * Local user
     * attributes: ThirdPartyLoggedIn / thirdPartyName / thirdPartyAlias / thirdPartyDepartment
     * does not participate in valoran refresh
     */
    fun update(localUser: ARoomUser) {
        this.streamId = localUser.streamId
        this.name = localUser.name
        //valoran does not return the source field, so this does not update the source
        //this.source = localUser.source

        // Biz User Info=that.streamId,
        this.uid = localUser.uid
        this.isHost = localUser.isHost
        this.isInterrupt = localUser.isInterrupt
        this.isCloudRecording = localUser.isCloudRecording
        this.issueDumpState = localUser.issueDumpState
        this.feature = localUser.feature
        this.portraitId = localUser.portraitId
        this.avatar = localUser.avatar
        this.inviteBy = localUser.inviteBy
        this.isAssistant = localUser.isAssistant
        this.online = localUser.online
        this.thirdPartyUid = localUser.thirdPartyUid
        this.isAttendee = localUser.isAttendee
        this.isDialing = localUser.isDialing

        // Media User Info=that.streamId,
        this.audioState = localUser.audioState
        this.isAudioPending = localUser.isAudioPending
        this.isVideoPending = localUser.isVideoPending
        this.videoState = localUser.videoState
        this.isSpeaking = localUser.isSpeaking
        this.quality = localUser.quality
        this.shareId = localUser.shareId
        this.parentStreamId = localUser.parentStreamId

        //stats
        this.volume = localUser.volume
        this.width = localUser.width
        this.height = localUser.height
        this.fps = localUser.fps
        this.bitrate = localUser.bitrate
        this.streamType = localUser.streamType
        this.rotation = localUser.rotation
    }

    fun updateUserInfo(userInfo: UserInfo) {
        this.name = userInfo.name
        this.portraitId = userInfo.portraitId
        this.streamId = userInfo.streamId
        this.uid = userInfo.uid
        this.token = userInfo.token

        val innerInfo = userInfo.innerInfo
        if (innerInfo != null) {
            this.isThirdPartyLoggedIn = true
            this.thirdPartyName = innerInfo.name
            this.thirdPartyAlias = innerInfo.alias
            this.thirdPartyDepartment = innerInfo.department
            this.thirdPartyInnerSession = innerInfo.innerSession
            this.source = innerInfo.source
        } else {
            this.isThirdPartyLoggedIn = false
            this.thirdPartyName = null
            this.thirdPartyAlias = null
            this.thirdPartyDepartment = null
            this.thirdPartyInnerSession = null
        }
    }

    fun removeInnerInfo() {
        this.isThirdPartyLoggedIn = false
        this.thirdPartyName = null
        this.thirdPartyAlias = null
        this.thirdPartyDepartment = null
    }

    override fun toString(): String {
        val toJson = GsonUtils.toJson(this)
        var jsonObject = JSONObject(toJson)
        jsonObject.remove("token")
        jsonObject.remove("thirdPartyInnerSession")
        return jsonObject.toString()
    }

}
