package io.agora.avc.bo

object NetworkQuality {

    // Avoid memory recycle, change enum to static int.
    const val UNKNOWN = 0
    const val EXCELLENT = 1
    const val GOOD = 2
    const val POOR = 3
    const val BAD = 4
    const val VBAD = 5
    const val DOWN = 6
    const val DETECTING = 8

    fun isGoodMile(quality: Int?): Boolean {
        return quality == EXCELLENT || quality == GOOD
    }

    fun isDetecting(quality: Int?): Boolean {
        return quality == DETECTING
    }

    fun isUnknown(quality: Int?): Boolean {
        return quality == UNKNOWN
    }

    fun allowShowMile(quality: Int?): Boolean {
        return !isGoodMile(quality) && !isDetecting(quality) && !isUnknown(quality)
    }
}
