package io.agora.avc.bo

import io.agora.avc.R
import io.agora.avc.utils.StringUtils

data class Room(
    val name: String,//room
    var pwd: String? = null,//room password
    val mode: Int,//room mode
    var audioState: Boolean = false,
    var videoState: Boolean = false,
    var topic: String? = null,//access token
    var createTime: Long? = null,//time when this room is created
    var key: String? = null,//comes with room-info at first join, can use key to rejoin room w/o pwd, when key is invalid, error 2017 is thrown
    var secure: Boolean? = null,
    var serverId: String? = null,//rtm serverId
    var rtmJoinedBefore: Boolean = false,//RTM joined the room successfully
    var timestamp: Long = 0,//room timestamp,use to remark rtc room info version
    var elapse: Long = 0,//room exist seconds
    var resolution: Int = 0,//room resolution
    var hostUid: String? = null,
    var hostName: String? = null,
    var hostThirdPartyName: String? = null,
    var hostThirdPartyAlias: String? = null,
) {
    fun getChannelId(): String {
        return if (isInternal()) {
            getPrivateChannelId()
        } else {
            getPublicChannelId()
        }
    }

    private fun getPublicChannelId(): String {
        return if (pwd?.isNotEmpty() == true) {
            "$name $pwd"
        } else {
            name
        }
    }

    private fun getPrivateChannelId(): String {
        return if (pwd?.isNotEmpty() == true) {
            "$name-$pwd"
        } else {
            name
        }
    }

    fun isInternal(): Boolean {
        return mode == RoomMode.AGORA.value
    }

    fun getConferenceNickname(): String {
        if (!hasHost()) {
            return StringUtils.getString(R.string.no_host)
        }
        val result = if (isInternal()) {
            getThirdPartyNickName()
        } else {
            hostName
        }
        if (result == null || result.isEmpty()) {
            return StringUtils.getString(R.string.unknown_user)
        }
        return result
    }

    fun getThirdPartyNickName(): String? {
        if (!StringUtils.isEmpty(hostThirdPartyAlias)) {
            return "$hostThirdPartyName(${hostThirdPartyAlias})"
        }
        return hostThirdPartyName
    }

    fun hasHost() = !StringUtils.isEmpty(hostUid)
}