package io.agora.avc.bo

/***
 * rtm operate command
 */
enum class UserSource(val key: String, val value: Int) {
    UNKNOWN("unknown", 0),
    AGORAN("agoran", 1),
    EMAIL("email", 2),
    EASEMOB("easemob", 3);

    companion object {
        fun parse(key: String): Int {
            return valueOf(key).value
        }

        fun parse(num: Int): String {
            for (value in values()) {
                if (value.value == num) {
                    return value.key
                }
            }
            return UNKNOWN.key
        }
    }
}