package io.agora.avc.bo.valoran

import com.agora.valoran.Constants
import io.agora.avc.bo.UserSource

/**
 * Used to take over [com.agora.valoran.bean.RoomUser] objects from valoran.
 *
 * If Valoran modifies the RoomInfo later
 * , the M layer and VM layer can be kept as intact as possible
 * , and only changes in this class are required.
 */
open class ARoomUser(
    var streamId: Int = 0,
    var name: String? = null,
    var source: Int = UserSource.UNKNOWN.value,

    // Biz User Info:,
    var uid: String? = null,
    var isHost: Boolean = false,
    var isInterrupt: Boolean = false,
    var isCloudRecording: Boolean = false,
    var issueDumpState: Int = 0,
    var feature: Int = 0,
    var portraitId: String? = null,
    var avatar: String? = null,
    var isThirdPartyLoggedIn: Boolean = false,
    var thirdPartyName: String? = null,
    var thirdPartyUid: String? = null,
    var thirdPartyAlias: String? = null,
    var thirdPartyDepartment: String? = null,
    var inviteBy: String? = null,
    var isAssistant: Boolean = false,
    var online: Boolean = false,
    var isAttendee: Boolean = false,
    var isDialing: Boolean = false,

    // Media User Info:,
    var audioState: Boolean = false,
    var isAudioPending: Boolean = false,
    var videoState: Boolean = false,
    var isVideoPending: Boolean = false,
    var isSpeaking: Boolean = false,
    var hasWatermark: Boolean = false,
    var quality: Int = 0,
    var shareId: Int = 0,
    var parentStreamId: Int = 0,

    //stats
    var volume: Int = 0,
    var width: Int = 0,
    var height: Int = 0,
    var fps: Int = 0,
    var bitrate: Int = 0,
    var streamType: Int = 0,
    var rotation: Int = 0,

    //highlight
    var nameStartPos: Int = 0,
    var nameEndPos: Int = 0,
    var thirdPartyNameStartPos: Int = 0,
    var thirdPartyNameEndPos: Int = 0,
    var thirdPartyAliasStartPos: Int = 0,
    var thirdPartyAliasEndPos: Int = 0,

    //assistant
    var showMedia: Boolean = true
) {
    /**
     * @suppress null == null return true
     */
    fun areTheSame(that: ARoomUser): Boolean {
        return (this.uid != null && this.uid?.isNotEmpty() == true && this.uid == that.uid)
                || (this.streamId != 0 && this.streamId == that.streamId)
    }

    fun isShareStream(): Boolean {
        return parentStreamId != 0
    }

    fun hasShareStream(): Boolean {
        return shareId != 0
    }

    fun isAudioDumping(): Boolean {
        return issueDumpState == Constants.ISSUE_DUMP_TYPE_AUDIO
    }

    fun logString(): String {
        return "{uid:${uid}, streamId:${streamId}, name=$name, thirdPartyName=$thirdPartyName}"
    }

    fun isMediaOn(): Boolean {
        return audioState || videoState
    }

    override fun toString(): String {
        return "ARoomUser(streamId=$streamId, name=$name, uid=$uid, isHost=$isHost, isInterrupt=$isInterrupt, feature=$feature, portraitId=$portraitId, isThirdPartyLoggedIn=$isThirdPartyLoggedIn, thirdPartyName=$thirdPartyName, thirdPartyAlias=$thirdPartyAlias, thirdPartyDepartment=$thirdPartyDepartment, inviteBy=$inviteBy, audioState=$audioState, videoState=$videoState, isSpeaking=$isSpeaking, quality=$quality, shareId=$shareId, parentStreamId=$parentStreamId, volume=$volume, width=$width, height=$height, fps=$fps, bitrate=$bitrate, streamType=$streamType, rotation=$rotation)"
    }

}