package io.agora.avc.config

import android.content.Context
import io.agora.avc.R
import io.agora.avc.manager.splite.SPLiteProxy
import io.agora.rtc.video.VideoEncoderConfiguration

val APP_ID = if (SPLiteProxy.isTestServer()) {
    "5a449ad258814922b76b72c938655762"
} else {
    "e995806877064826ad75cccc69c01304"
}

const val DEFAULT_AVATAR_ID = "1"
const val RESOLUTION_LOW = 0
const val RESOLUTION_MEDIUM = 1
const val RESOLUTION_HIGH = 2
const val RESOLUTION_MAX = RESOLUTION_HIGH
const val RESOLUTION_DEFAULT = RESOLUTION_MEDIUM
const val MAX_UPLOAD_IMAGE_SIZE = 1024 * 1024L
const val KEY_REQUEST_ID = "key_request_id"


fun resolutionDescription(context: Context, resolution: Int) =
    when (resolution) {
        RESOLUTION_LOW -> context.getString(R.string.me_resolution_low)
        RESOLUTION_MEDIUM -> context.getString(R.string.me_resolution_medium)
        else -> context.getString(R.string.me_resolution_high)
    }

fun resolutionDetail(resolution: Int) =
    when (resolution) {
        RESOLUTION_LOW -> "360P"
        RESOLUTION_MEDIUM -> "480P"
        else -> "720P"
    }

fun getVideoDimension(resolution: Int): VideoEncoderConfiguration.VideoDimensions {
    return when (resolution) {
        RESOLUTION_LOW -> VideoEncoderConfiguration.VideoDimensions(640, 360)
        RESOLUTION_MEDIUM -> VideoEncoderConfiguration.VideoDimensions(640, 480)
        else -> VideoEncoderConfiguration.VideoDimensions(960, 720)
    }
}

const val PREFIX_INTERNAL_MEETING = "AG-"
