package io.agora.avc.config

import android.content.Context
import io.agora.avc.BuildConfig
import io.agora.avc.MyApplication
import io.agora.avc.manager.bi.BIManagerImpl
import io.agora.avc.net.constant.Constants
import io.agora.avc.net.converter.CustomConverter
import io.agora.avc.net.interceptor.*
import io.agora.frame.config.FrameConfigModule
import io.agora.frame.di.module.ConfigModule
import io.agora.frame.http.interceptor.HttpLogInterceptor
import okhttp3.CertificatePinner
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory
import java.util.concurrent.TimeUnit

/**
 * Custom global configuration
 */
class AppConfigModule : FrameConfigModule() {
    private val timeout = 15L
    override fun applyOptions(context: Context, builder: ConfigModule.Builder) {
        builder.baseUrl(Constants.getBaseUrl()) //baseUrl
            .retrofitOptions {
                it
                    .addCallAdapterFactory(RxJava2CallAdapterFactory.create())
                    .addConverterFactory(CustomConverter.create())
            }
            .okHttpClientOptions {
                it.retryOnConnectionFailure(true)
                    .connectTimeout(timeout, TimeUnit.SECONDS)
                    .writeTimeout(timeout, TimeUnit.SECONDS)
                    .readTimeout(timeout, TimeUnit.SECONDS)
                if (BuildConfig.DEBUG) {
                    it.addNetworkInterceptor(HttpLogInterceptor(BuildConfig.DEBUG))
                } else {
                    it.addNetworkInterceptor(LogInterceptor())
                }
                it.addInterceptor(NetworkInterceptor())//network
                    .addInterceptor(TokenBadInterceptor(context))//common params
                    .addInterceptor(HeaderParamsInterceptor(context))//common params
                    .addInterceptor(HostDispatcherInterceptor())//host dispatch
                if (context is MyApplication) {
                    it.addInterceptor(BiInterceptor(BIManagerImpl(context)))//bi record
                }
                it.hostnameVerifier { hostname, _ -> hostname == Constants.HOST_DEBUG || hostname == Constants.HOST_RELEASE }
                val certificatePinner = CertificatePinner.Builder()
                    .add(Constants.HOST_DEBUG, Constants.HOST_DEBUG_SHA256_1)
                    .add(Constants.HOST_DEBUG, Constants.HOST_DEBUG_SHA256_2)
                    .add(Constants.HOST_DEBUG, Constants.HOST_DEBUG_SHA256_3)
                    .add(Constants.HOST_RELEASE, Constants.HOST_RELEASE_SHA256_1)
                    .add(Constants.HOST_RELEASE, Constants.HOST_RELEASE_SHA256_2)
                    .add(Constants.HOST_RELEASE, Constants.HOST_RELEASE_SHA256_3)
                    .build()
                it.certificatePinner(certificatePinner)
            }
            .gsonOptions {
                //Gson options
            }
    }
}