package io.agora.avc.dao

import androidx.room.*
import io.agora.avc.po.Attach

@Dao
interface AttachDao {
    @Query("SELECT * FROM `attach`")
    fun getAll(): List<Attach>

    @Query("SELECT * FROM `attach` WHERE id IN (:ids)")
    fun loadAllByIds(ids: LongArray): List<Attach>

    @Insert
    fun insert(attach: Attach): Long

    @Insert
    fun insertAll(vararg attach: Attach)

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    fun insertAll(list: List<Attach>)

    @Delete
    fun delete(attach: Attach)

    @Update
    fun update(attach: Attach)
}