package io.agora.avc.dao

import androidx.room.*
import io.agora.avc.po.IncomingRecord

@Dao
interface IncomingRecordDao {
    @Query("SELECT * FROM `incoming_record`")
    fun getAll(): List<IncomingRecord>

    @Query("SELECT * FROM `incoming_record` WHERE requestId = :id")
    fun getRecord(id: String): IncomingRecord

    @Insert
    fun insert(incomingRecord: IncomingRecord): Long

    @Insert
    fun insertAll(vararg incomingRecord: IncomingRecord)

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    fun insertAll(list: List<IncomingRecord>)

    @Delete
    fun delete(incomingRecord: IncomingRecord)

    @Update
    fun update(incomingRecord: IncomingRecord)
}