package io.agora.avc.di.module

import dagger.Binds
import dagger.Module
import io.agora.avc.auth.signin.SignInManager
import io.agora.avc.auth.signin.SignInManagerImpl
import io.agora.avc.auth.signin.google.GoogleSignInImpl
import io.agora.avc.auth.signin.google.GoogleSignInManager
import io.agora.avc.auth.signin.wework.WeWorkManager
import io.agora.avc.auth.signin.wework.WeWorkManagerImpl
import io.agora.avc.biz.AppController
import io.agora.avc.biz.AppControllerImp
import io.agora.avc.biz.event.AppEventBus
import io.agora.avc.biz.event.AppEventBusImp
import io.agora.avc.biz.vlr.IVlrClient
import io.agora.avc.biz.vlr.VlrClientImp
import io.agora.avc.manager.audiodump.AudioDumper
import io.agora.avc.manager.audiodump.AudioDumperImpl
import io.agora.avc.manager.bi.BIManager
import io.agora.avc.manager.bi.BIManagerImpl
import io.agora.avc.manager.bugreport.BugReporter
import io.agora.avc.manager.bugreport.BugReporterImpl
import io.agora.avc.manager.link.LinkManager
import io.agora.avc.manager.link.LinkManagerImpl
import io.agora.avc.manager.logupload.LogUploader
import io.agora.avc.manager.logupload.LogUploaderImpl
import io.agora.avc.manager.media.MediaPlayer
import io.agora.avc.manager.media.MediaPlayerImpl
import io.agora.avc.manager.network.NetWorkManager
import io.agora.avc.manager.network.NetWorkManagerImpl
import io.agora.avc.manager.notice.NoticeManager
import io.agora.avc.manager.notice.NoticeManagerImpl
import io.agora.avc.manager.notice.notification.NotificationManager
import io.agora.avc.manager.notice.notification.NotificationManagerImpl
import io.agora.avc.manager.quality.QualityManager
import io.agora.avc.manager.quality.QualityManagerImpl
import io.agora.avc.manager.rating.call.CallRatingManager
import io.agora.avc.manager.rating.call.CallRatingManagerImpl
import io.agora.avc.manager.rating.video.VideoRatingManager
import io.agora.avc.manager.rating.video.VideoRatingManagerImpl
import io.agora.avc.manager.splite.SPLite
import io.agora.avc.manager.splite.SPLiteImp
import io.agora.avc.manager.time.TimeManager
import io.agora.avc.manager.time.TimeManagerImpl
import io.agora.avc.manager.translation.TranslationManager
import io.agora.avc.manager.translation.TranslationManagerImpl
import io.agora.avc.manager.upgrade.AppUpgradeManager
import io.agora.avc.manager.upgrade.AppUpgradeManagerImpl
import io.agora.avc.push.PushDataRepository
import io.agora.avc.push.PushDataRepositoryImpl
import io.agora.avc.repository.*
import io.agora.avc.repository.impl.*
import io.agora.frame.di.scope.ApplicationScope

@Module
abstract class ApplicationModule {

    @ApplicationScope
    @Binds
    abstract fun provideSPLite(spLite: SPLiteImp): SPLite

    @ApplicationScope
    @Binds
    abstract fun provideAppConfigRepository(appConfig: AppConfigRepositoryImpl): AppConfigRepository

    @ApplicationScope
    @Binds
    abstract fun provideUserRepository(userRepository: UserRepositoryImpl): UserRepository

    @ApplicationScope
    @Binds
    abstract fun provideRoomRepository(roomRepository: RoomRepositoryImpl): RoomRepository

    @ApplicationScope
    @Binds
    abstract fun provideVlrClient(vlrClient: VlrClientImp): IVlrClient

    @ApplicationScope
    @Binds
    abstract fun provideChatRepository(chatRepository: ChatRepositoryImpl): ChatRepository

    @ApplicationScope
    @Binds
    abstract fun provideDeveloperRepository(developerRepository: DeveloperRepositoryImpl): DeveloperRepository

    @ApplicationScope
    @Binds
    abstract fun provideMediaConfigRepository(mediaConfigRepository: MediaConfigRepositoryImpl): MediaConfigRepository

    @ApplicationScope
    @Binds
    abstract fun provideLogUploader(logUploader: LogUploaderImpl): LogUploader

    @ApplicationScope
    @Binds
    abstract fun provideAppController(appController: AppControllerImp): AppController

    @ApplicationScope
    @Binds
    abstract fun provideAppEventBus(appEventBus: AppEventBusImp): AppEventBus

    @ApplicationScope
    @Binds
    abstract fun provideWeWorkManager(weWorkManager: WeWorkManagerImpl): WeWorkManager

    @ApplicationScope
    @Binds
    abstract fun provideLinkManager(linkManager: LinkManagerImpl): LinkManager

    @ApplicationScope
    @Binds
    abstract fun provideQualityManager(qualityManager: QualityManagerImpl): QualityManager

    @ApplicationScope
    @Binds
    abstract fun provideVideoRatingManager(videoRatingManager: VideoRatingManagerImpl): VideoRatingManager

    @ApplicationScope
    @Binds
    abstract fun provideAudioDumper(audioDumper: AudioDumperImpl): AudioDumper

    @ApplicationScope
    @Binds
    abstract fun provideProblemRepository(problemRepository: ProblemRepositoryImpl): ProblemRepository

    @ApplicationScope
    @Binds
    abstract fun provideBugReporter(bugReporter: BugReporterImpl): BugReporter

    @ApplicationScope
    @Binds
    abstract fun provideTimeManager(timeManager: TimeManagerImpl): TimeManager

    @ApplicationScope
    @Binds
    abstract fun provideBIManager(biManager: BIManagerImpl): BIManager

    @ApplicationScope
    @Binds
    abstract fun provideAppUpgradeManager(appUpgradeManager: AppUpgradeManagerImpl): AppUpgradeManager

    @ApplicationScope
    @Binds
    abstract fun provideNoticeManager(noticeManager: NoticeManagerImpl): NoticeManager

    @ApplicationScope
    @Binds
    abstract fun provideMediaPlayer(mediaPlayer: MediaPlayerImpl): MediaPlayer

    @ApplicationScope
    @Binds
    abstract fun provideTranslationManager(translationManager: TranslationManagerImpl): TranslationManager

    @ApplicationScope
    @Binds
    abstract fun provideCallRatingManager(callRatingManager: CallRatingManagerImpl): CallRatingManager

    @ApplicationScope
    @Binds
    abstract fun providePushDataRepository(pushDataRepository: PushDataRepositoryImpl): PushDataRepository

    @ApplicationScope
    @Binds
    abstract fun provideAddressBookRepository(addressBookRepository: AddressBookRepositoryImpl): AddressBookRepository

    @ApplicationScope
    @Binds
    abstract fun provideNotificationRepository(notificationRepository: NotificationRepositoryImpl): NotificationRepository

    @ApplicationScope
    @Binds
    abstract fun provideNotificationManager(notificationManager: NotificationManagerImpl): NotificationManager

    @ApplicationScope
    @Binds
    abstract fun provideNetWorkManager(netWorkManager: NetWorkManagerImpl): NetWorkManager

    @ApplicationScope
    @Binds
    abstract fun provideGoogleSignInManager(googleSignInManager: GoogleSignInImpl): GoogleSignInManager

    @ApplicationScope
    @Binds
    abstract fun provideSignInManager(signInManagerImpl: SignInManagerImpl): SignInManager

    @ApplicationScope
    @Binds
    abstract fun provideEquipmentRepository(equipmentRepository: EquipmentRepositoryImpl): EquipmentRepository
}