package io.agora.avc.extensions

import android.app.Activity
import android.view.View
import android.view.Window
import androidx.core.view.WindowCompat
import androidx.core.view.WindowInsetsCompat
import androidx.core.view.WindowInsetsControllerCompat

fun Activity.setStatusBarVisibility(isVisible: Boolean) {
    window?.setStatusBarVisibility(isVisible)
}

fun Activity.setNavBarVisibility(isVisible: Boolean) {
    window?.setNavBarVisibility(isVisible)
}

fun Window.setStatusBarVisibility(isVisible: Boolean) {
    setSystemBarVisibility(WindowInsetsCompat.Type.statusBars(), isVisible)
}

fun Window.setNavBarVisibility(isVisible: Boolean) {
    setSystemBarVisibility(WindowInsetsCompat.Type.navigationBars(), isVisible)
}

fun Window.setSystemBarVisibility(
    @WindowInsetsCompat.Type.InsetsType types: Int,
    isVisible: Boolean
) {
    val insetsControllerCompat = WindowCompat.getInsetsController(this, this.decorView)
    if (insetsControllerCompat != null) {
        insetsControllerCompat.systemBarsBehavior =
            WindowInsetsControllerCompat.BEHAVIOR_SHOW_TRANSIENT_BARS_BY_SWIPE
        if (isVisible) {
            insetsControllerCompat.show(types)
        } else {
            insetsControllerCompat.hide(types)
        }
    }
}

fun Window.transparentNavBar() {
    decorView.apply {
        systemUiVisibility = systemUiVisibility or (View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION
                or View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY)
    }
}