package io.agora.avc.extensions

import android.os.Bundle
import android.view.View
import androidx.annotation.IdRes
import androidx.fragment.app.Fragment
import androidx.navigation.fragment.NavHostFragment
import io.agora.avc.utils.BarUtils
import io.agora.logger.Logger
import kotlin.reflect.KClass

fun Fragment.safeNavigate(@IdRes resId: Int) {
    safeNavigate(resId, null)
}

fun Fragment.safeNavigate(@IdRes resId: Int, args: Bundle?) {
    if (isAdded) {
        try {
            NavHostFragment.findNavController(this).navigate(resId, args)
        } catch (e: IllegalArgumentException) {
            Logger.w("Navigation", "cannot be found from the current destination")
        }
    }
}

fun Fragment.findFragment(clazz: KClass<*>): Fragment? {
    childFragmentManager.fragments.let {
        it.forEach { _fragment ->
            if (_fragment::class == clazz) {
                return _fragment
            }
        }
    }
    return null
}

fun Fragment.navigateUpIfInTop(clazz: KClass<out Fragment>) {
    childFragmentManager.fragments.let {
        if (it.isNotEmpty() && it[0]::class == clazz) {
            NavHostFragment.findNavController(this).navigateUp()
            return
        }
    }
    parentFragmentManager.fragments.let {
        if (it.isNotEmpty() && it[it.size - 1]::class == clazz) {
            NavHostFragment.findNavController(this).navigateUp()
            return
        }
    }
}