package io.agora.avc.extensions

import com.google.gson.JsonArray
import com.google.gson.JsonElement
import com.google.gson.JsonNull
import com.google.gson.JsonObject

fun JsonElement.getString(): String? {
    if (this is JsonNull) {
        return null
    }
    try {
        return asString
    } catch (e: Exception) {
        e.printStackTrace()
    }
    return null
}

fun JsonElement.getBoolean(): Boolean {
    if (this is JsonNull) {
        return false
    }
    try {
        return asBoolean
    } catch (e: Exception) {
        e.printStackTrace()
    }
    return false
}

fun JsonElement.getNumber(): Number? {
    if (this is JsonNull) {
        return null
    }
    try {
        return asNumber
    } catch (e: Exception) {
        e.printStackTrace()
    }
    return null
}

fun JsonElement.getJsonObject(): JsonObject? {
    if (this is JsonNull) {
        return null
    }
    try {
        return asJsonObject
    } catch (e: Exception) {
        e.printStackTrace()
    }
    return null
}

fun JsonElement.getJsonArray(): JsonArray? {
    if (this is JsonNull) {
        return null
    }
    try {
        return asJsonArray
    } catch (e: Exception) {
        e.printStackTrace()
    }
    return null
}

fun JsonElement.getDouble(): Double? {
    if (this is JsonNull) {
        return null
    }
    try {
        return asDouble
    } catch (e: Exception) {
        e.printStackTrace()
    }
    return null
}

fun JsonElement.getFloat(): Float? {
    if (this is JsonNull) {
        return null
    }
    try {
        return asFloat
    } catch (e: Exception) {
        e.printStackTrace()
    }
    return null
}

fun JsonElement.getLong(): Long? {
    if (this is JsonNull) {
        return null
    }
    try {
        return asLong
    } catch (e: Exception) {
        e.printStackTrace()
    }
    return null
}

fun JsonElement.getInt(): Int? {
    if (this is JsonNull) {
        return null
    }
    try {
        return asInt
    } catch (e: Exception) {
        e.printStackTrace()
    }
    return null
}
