package io.agora.avc.functions

import io.agora.logger.Logger
import io.reactivex.Observable
import io.reactivex.functions.Function
import java.util.concurrent.TimeUnit

const val DEFAULT_INTERVAL = 5L

class RetryForever(private val interval: Long = DEFAULT_INTERVAL) :
    Function<Observable<out Throwable?>, Observable<*>> {

    @Throws(Exception::class)
    override fun apply(observable: Observable<out Throwable?>): Observable<*> {
        return observable
            .flatMap { error ->
                Logger.e(TAG, "retry error:${error?.message}")
                Observable.timer(
                    interval,
                    TimeUnit.SECONDS
                )
            }
    }

    companion object {
        private const val TAG = "[Comm][Http]"
    }
}