package io.agora.avc.functions

import io.reactivex.Observable
import io.reactivex.functions.BiFunction
import io.reactivex.functions.Function
import java.util.concurrent.TimeUnit
import kotlin.math.pow

/**
 * test if params retries is too large,will effect cpu & memory
 * @param retries
 */
class RetryFunction(private val interval: Long, private val retries: Int) :
    Function<Observable<out Throwable?>, Observable<*>> {
    @Throws(Exception::class)
    override fun apply(observable: Observable<out Throwable?>): Observable<*> {
        return observable.zipWith(
            Observable.range(1, retries),
            BiFunction<Throwable?, Int, Any> { _, integer -> integer })
            .flatMap { retryCount ->
                Observable.timer(
                    interval.toDouble().pow(retryCount.toString().toDouble()).toLong(),
                    TimeUnit.SECONDS
                )
            }
    }
}