package io.agora.avc.listener

import android.view.View
import io.agora.logger.Logger

abstract class AntiShakeClickListener : View.OnClickListener {
    private var lastClickTime = 0L
    private var delayTime = 500

    abstract fun onAntiShakeClicked(view: View?)

    private fun isFastDoubleClick(): Boolean {
        if ((System.currentTimeMillis() - lastClickTime) > delayTime) {
            lastClickTime = System.currentTimeMillis()
            return false
        }
        lastClickTime = System.currentTimeMillis()
        Logger.d(TAG, "discard quick click events")
        return true
    }

    override fun onClick(v: View?) {
        if (!isFastDoubleClick()) {
            onAntiShakeClicked(v)
        }
    }

    companion object {
        private const val TAG = "[UI][AntiShakeClick]"
    }
}