package io.agora.avc.listener

import android.view.View
import io.agora.avc.R
import io.agora.avc.utils.ToastUtils

abstract class DeveloperClickedListener(var showDeveloper: Boolean) :
    View.OnClickListener {
    private var lastClickTime = 0L
    private var devClickCount = 0

    abstract fun onDeveloperClicked(view: View?)

    override fun onClick(v: View?) {
        if (showDeveloper) {
            ToastUtils.showShort(R.string.developer_mode_already_toast)
            return
        }

        if ((System.currentTimeMillis() - lastClickTime) > 2000) {
            devClickCount = 0
        }

        devClickCount++

        if (devClickCount > 5) {
            ToastUtils.showShort(R.string.developer_mode_toast)
            onDeveloperClicked(v)
        }

        lastClickTime = System.currentTimeMillis()
    }

    companion object {
        private const val TAG = "[UI][AntiShakeClick]"
    }
}