package io.agora.avc.listener

import android.view.View

abstract class EnvironmentClickedListener : View.OnClickListener {
    private var lastClickTime = 0L
    private var devClickCount = 0

    abstract fun onEnvironmentClicked(view: View?)

    override fun onClick(v: View?) {
        if ((System.currentTimeMillis() - lastClickTime) > 2000) {
            devClickCount = 0
        }
        devClickCount++
        if (devClickCount > 5) {
            onEnvironmentClicked(v)
        }
        lastClickTime = System.currentTimeMillis()
    }

    companion object {
        private const val TAG = "[UI][AntiShakeClick]"
    }
}