package io.agora.avc.manager.bugreport

import androidx.annotation.IntDef

@IntDef(
    DumpStatus.NONE,
    DumpStatus.DUMPING,
    DumpStatus.PREPARE,
    DumpStatus.FINISHED,
)
annotation class DumpStatus {
    companion object {
        const val NONE = 0
        const val DUMPING = 1
        const val PREPARE = 2
        const val FINISHED = 3

        fun convertToLog(dumpStatus: Int) = when (dumpStatus) {
            DUMPING -> {
                "dumping"
            }
            PREPARE -> {
                "prepare"
            }
            FINISHED -> {
                "finished"
            }
            else -> {
                "none"
            }
        }

    }
}