package io.agora.avc.manager.link

import android.net.Uri
import io.agora.avc.bo.LocalUser
import io.agora.avc.bo.Room

interface LinkManager {

    /**
     * @param rid room name
     * @param pwd room password
     * @param nickName ARoomUser's nickName @see[io.agora.avc.extensions.getThirdPartyNickName]
     * @param type
     * @param code
     */
    fun createShareLinkFromServer(
        rid: String,
        pwd: String?,
        nickName: String?
    )

    fun createAgoraLink2Clipboard(
        rid: String,
        pwd: String?,
        nickName: String?,
        type: Int,
        code: String? = null
    )

    fun createShareLink2Clipboard(
        username: String,
        rid: String,
        pwd: String?
    )

    fun handleSchemeLink(data: Uri, roomInfo: Room?, localUser: LocalUser)
}