package io.agora.avc.manager.notice

import android.app.NotificationChannel
import android.app.NotificationManager
import android.content.Context
import android.os.Build
import androidx.annotation.StringRes
import androidx.core.app.NotificationManagerCompat
import androidx.core.content.ContextCompat
import io.agora.avc.R

object NotificationController {
    // CHANNEL_ID must not changed through versions
    const val SCREEN_SHARE_CHANNEL_ID = "io.agora.avc.screenshare.ScreenShareService"
    const val MEETING_EVENT_CHANNEL_ID = "MEETING_EVENT_CHANNEL_ID"
    const val DAEMON_CHANNEL_ID = "io.agora.avc.service.DaemonService"
    const val NOTICE_CHANNEL_ID = "NOTICE_CHANNEL_ID"

    fun createNotificationChannel(
        context: Context,
        channelId: String,
        @StringRes nameResId: Int,
        @StringRes desResId: Int
    ) {
        val notificationManager =
            ContextCompat.getSystemService(
                context,
                NotificationManager::class.java
            ) as NotificationManager

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            if (notificationManager.getNotificationChannel(channelId) == null) {
                var importance = if (channelId == MEETING_EVENT_CHANNEL_ID) {
                    NotificationManager.IMPORTANCE_HIGH
                } else {
                    NotificationManager.IMPORTANCE_DEFAULT
                }
                val notificationChannel = NotificationChannel(
                    channelId,
                    context.getString(nameResId),
                    importance
                )
                if (channelId == SCREEN_SHARE_CHANNEL_ID
                    || channelId == DAEMON_CHANNEL_ID
                ) {
                    notificationChannel.setSound(null, null)
                    notificationChannel.enableLights(false)
                    notificationChannel.enableVibration(false)
                }
                notificationChannel.description = context.getString(desResId)
                notificationManager.createNotificationChannel(notificationChannel)
            }
        }
    }

    fun createSmallIcon(): Int {
        return if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            R.drawable.metroon_icon_status_bar
        } else {
            R.mipmap.ic_launcher
        }
    }
}