package io.agora.avc.manager.splite

import io.agora.avc.bo.AppConfig
import io.agora.avc.bo.AppTips
import io.agora.avc.bo.DevConfig
import io.agora.avc.bo.InnerInfo

object SPLiteProxy : SPLite {

    private var spLite: SPLite? = null

    fun setSpLite(spLite: SPLite) {
        SPLiteProxy.spLite = spLite
    }

    override fun migrate() {
        spLite?.migrate()
    }

    override fun getInnerInfo(): InnerInfo? {
        return spLite?.getInnerInfo()
    }

    override fun setInnerInfo(value: InnerInfo?) {
        spLite?.setInnerInfo(value)
    }

    override fun getLastVersion(): String {
        return spLite?.getLastVersion() ?: ""
    }

    override fun setLastVersion(value: String) {
        spLite?.setLastVersion(value)
    }

    override fun getNotice(): String {
        return spLite?.getNotice() ?: ""
    }

    override fun setNotice(value: String) {
        spLite?.setNotice(value)
    }

    override fun getUserName(): String {
        return spLite?.getUserName() ?: ""
    }

    override fun setUserName(value: String) {
        spLite?.setUserName(value)
    }

    override fun getPortraitId(): String {
        return spLite?.getPortraitId() ?: ""
    }

    override fun setPortraitId(value: String) {
        spLite?.setPortraitId(value)
    }

    override fun getAccessToken(): String {
        return spLite?.getAccessToken() ?: ""
    }

    override fun getRtmToken(): String {
        return spLite?.getRtmToken() ?: ""
    }

    override fun setRtmToken(value: String) {
        spLite?.setRtmToken(value)
    }

    override fun getUserInfo(): String {
        return spLite?.getUserInfo() ?: ""
    }

    override fun setUserInfo(value: String) {
        spLite?.setUserInfo(value)
    }

    override fun getAudioSetting(): Boolean {
        return spLite?.getAudioSetting() ?: true
    }

    override fun setAudioSetting(value: Boolean) {
        spLite?.setAudioSetting(value)
    }

    override fun getVideoSetting(): Boolean {
        return spLite?.getVideoSetting() ?: true
    }

    override fun setVideoSetting(value: Boolean) {
        spLite?.setVideoSetting(value)
    }

    override fun getDarkTheme(): Int {
        return spLite?.getDarkTheme() ?: -1
    }

    override fun setDarkTheme(value: Int) {
        spLite?.setDarkTheme(value)
    }

    override fun getDevelopMode(): Boolean {
        return spLite?.getDevelopMode() ?: false
    }

    override fun setDevelopMode(value: Boolean) {
        spLite?.setDevelopMode(value)
    }

    override fun getShowWelcome(): Boolean {
        return spLite?.getShowWelcome() ?: false
    }

    override fun setShowWelcome(value: Boolean) {
        spLite?.setShowWelcome(value)
    }

    override fun privacyShowed(): Boolean {
        return spLite?.privacyShowed() ?: false
    }

    override fun setShowPrivacy(value: Boolean) {
        spLite?.setShowPrivacy(value)
    }

    override fun getResolutionOption(): Int {
        return spLite?.getResolutionOption() ?: 1
    }

    override fun setResolutionOption(value: Int) {
        spLite?.setResolutionOption(value)
    }

    override fun getRoomSecure(): Boolean {
        return spLite?.getRoomSecure() ?: true
    }

    override fun setRoomSecure(value: Boolean) {
        spLite?.setRoomSecure(value)
    }

    override fun getPictureMode(): Boolean {
        return spLite?.getPictureMode() ?: true

    }

    override fun setPictureMode(value: Boolean) {
        spLite?.setPictureMode(value)
    }

    override fun getRtcParameters(): Set<String> {
        return spLite?.getRtcParameters() ?: HashSet()
    }

    override fun setRtcParameters(value: Set<String>) {
        spLite?.setRtcParameters(value)
    }

    override fun isTestServer(): Boolean {
        return spLite?.isTestServer() ?: true
    }

    override fun setTestServer(value: Boolean) {
        spLite?.setTestServer(value)
    }

    override fun getRtcMediaCopy(): Boolean {
        return spLite?.getRtcMediaCopy() ?: false
    }

    override fun setRtcMediaCopy(value: Boolean) {
        spLite?.setRtcMediaCopy(value)
    }

    override fun getAvcGuid(): String {
        return spLite?.getAvcGuid() ?: ""
    }

    override fun setAvcGuid(value: String) {
        spLite?.setAvcGuid(value)
    }

    override fun clear() {
        spLite?.clear()
    }

    override fun clearToken() {
        spLite?.clearToken()
    }

    override fun getAppTips(): AppTips? {
        return spLite?.getAppTips()
    }

    override fun setAppTips(appTips: AppTips?) {
        spLite?.setAppTips(appTips)
    }

    override fun clearAppTips() {
        spLite?.clearAppTips()
    }

    override fun setRoomMode(mode: Int) {
        spLite?.setRoomMode(mode)
    }

    override fun getRoomMode(): Int {
        return spLite?.getRoomMode() ?: 0
    }

    override fun saveAppConfig(config: String) {
        spLite?.saveAppConfig(config)
    }

    override fun getAppConfig(): AppConfig? {
        return spLite?.getAppConfig()
    }

    override fun saveDevConfig(config: String) {
        spLite?.saveDevConfig(config)
    }

    override fun getDevConfig(): DevConfig? {
        return spLite?.getDevConfig()
    }

    override fun saveOpenNotificationGuideTime(time: Long) {
        spLite?.saveOpenNotificationGuideTime(time)
    }

    override fun getOpenNotificationGuideTime() = spLite?.getOpenNotificationGuideTime()

    override fun getDeviceUUID(): String? {
        return spLite?.getDeviceUUID()
    }

    override fun saveDeviceUUID(uuid: String) {
        spLite?.saveDeviceUUID(uuid)
    }

    override fun saveBannerNotificationGuideTime(time: Long) {
        spLite?.saveBannerNotificationGuideTime(time)
    }

    override fun getBannerNotificationGuideTime() = spLite?.getBannerNotificationGuideTime()
}