package io.agora.avc.manager.translation

import com.github.promeg.pinyinhelper.Pinyin
import io.agora.avc.bo.PinyinInfo
import java.util.concurrent.ConcurrentHashMap
import javax.inject.Inject

class TranslationManagerImpl @Inject constructor() : TranslationManager {
    private val data = ConcurrentHashMap<String, PinyinInfo>()

    override fun hanzi2Pinyin(input: String): PinyinInfo {
        val pinyinInfo = data[input]
        if (pinyinInfo != null) {
            return pinyinInfo
        }
        val fullBuilder = StringBuilder()
        val smallBuilder = StringBuilder()
        val number = mutableListOf<Int>()
        for (c in input) {
            if (Pinyin.isChinese(c)) {
                val toPinyin = Pinyin.toPinyin(c)
                fullBuilder.append(toPinyin.toLowerCase())
                smallBuilder.append(toPinyin.toLowerCase()[0])
                number.add(toPinyin.length)
            } else {
                fullBuilder.append(c.toLowerCase())
                smallBuilder.append(c.toLowerCase())
                number.add(1)
            }
        }
        val result = PinyinInfo(
            input,
            fullBuilder.toString(),
            smallBuilder.toString(),
            number.toIntArray()
        )
        data[input] = result
        return result
    }

    override fun existChinese(input: String): Boolean {
        for (c in input) {
            if (Pinyin.isChinese(c)) {
                return true
            }
        }
        return false
    }

}