package io.agora.avc.net

import io.agora.avc.R
import io.agora.avc.net.bean.BaseNo
import io.agora.avc.net.exception.NetworkErrorException
import io.agora.avc.utils.StringUtils
import io.agora.avc.utils.ToastUtils
import io.agora.logger.Logger
import io.reactivex.Observer
import io.reactivex.disposables.Disposable

abstract class BaseObserver<T : BaseNo?> : Observer<T?> {
    override fun onSubscribe(d: Disposable) {}
    override fun onNext(t: T) {
        try {
            if (t != null && t.success) {
                onSuccess(t)
            } else {
                onFail(t)
            }
        } catch (e: Exception) {
            Logger.e(TAG, "http request exception", e)
        }
    }

    override fun onError(e: Throwable) {
        Logger.e(TAG, "http request exception", e)
        onFail(null)
        if (e is NetworkErrorException) {
            ToastUtils.showShort(StringUtils.getString(R.string.network_invalid))
        }
    }

    override fun onComplete() {}
    abstract fun onSuccess(t: T?)
    abstract fun onFail(t: T?)

    companion object {
        private const val TAG = "[Comm][Http]"

    }
}