package io.agora.avc.net.constant

import io.agora.avc.manager.splite.SPLiteProxy

object Constants {
    const val LOG_BASE_URL = "http://upload.agora.io/"
    const val HOST_DEBUG = "siren-qa.sh2.agoralab.co"
    const val HOST_RELEASE = "videocall.agora.io"

    const val HOST_DEBUG_SHA256_1 = "sha256/ZYbgaT0CHfn48OnR9wktzgfKxbpIEBcEf/XwgguWDJc="
    const val HOST_DEBUG_SHA256_2 = "sha256/jQJTbIh0grw0/1TkHSumWb+Fs0Ggogr621gT3PvPKG0="
    const val HOST_DEBUG_SHA256_3 = "sha256/C5+lpZ7tcVwmwQIMcRtPbsQtWLABXhQzejna0wHFr8M="
    const val HOST_RELEASE_SHA256_1 = "sha256/p7XuSn7Iujda63NxTa9oO9XmCWKcx0LTsYuG/oitx9g="
    const val HOST_RELEASE_SHA256_2 = "sha256/8Rw90Ej3Ttt8RRkrg+WYDS9n7IS03bk5bjP/UXPtaY8="
    const val HOST_RELEASE_SHA256_3 = "sha256/Ko8tivDrEjiY90yGasP6ZpBU4jwXvHqVvQI0GS3GNdA="

    private const val RELEASE_BASE_URL = "https://videocall.agora.io/"
    private const val DEBUG_BASE_URL = "https://siren-qa.sh2.agoralab.co/"
    private const val RELEASE_ATLAS_RECORDING_URL = "https://atlas.agoralab.co/recording/search"
    private const val DEBUG_ATLAS_RECORDING_URL =
        "https://atlas-staging.agoralab.co/recording/search"

    fun getBaseUrl(): String {
        return if (SPLiteProxy.isTestServer()) DEBUG_BASE_URL else RELEASE_BASE_URL
    }

    fun getAvatar(portraitId: String?): String {
        return getBaseUrl() + "usrservice/v1/account/portrait?portraitId=$portraitId"
    }

    fun getAtlasRecordingUrl(): String {
        return if (SPLiteProxy.isTestServer()) DEBUG_ATLAS_RECORDING_URL else RELEASE_ATLAS_RECORDING_URL
    }

}