package io.agora.avc.net.interceptor

import io.agora.avc.net.exception.NetworkErrorException
import io.agora.avc.utils.NetworkUtils
import okhttp3.Interceptor
import okhttp3.Response


class NetworkInterceptor : Interceptor {
    override fun intercept(chain: Interceptor.Chain): Response {
        if (chain.request().cacheControl.isPublic) {
            return chain.proceed(chain.request())
        }
        return if (NetworkUtils.isConnected()) {
            chain.proceed(chain.request())
        } else {
            throw NetworkErrorException("network error,request url:${chain.request().url}")
        }
    }
}