package io.agora.avc.notification

import android.app.NotificationManager
import android.content.Context
import android.os.Build
import androidx.core.app.NotificationManagerCompat
import io.agora.avc.R

open class BaseNotification(private val channelId: String, context: Context) {

    val notificationManager by lazy {
        NotificationManagerCompat.from(context.applicationContext)
    }

    fun createSmallIcon(): Int {
        return R.drawable.metroon_icon_status_bar
    }

    fun isNeedPlaySound(): Boolean {
        if (!notificationManager.areNotificationsEnabled()) {
            return false
        }
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            notificationManager.getNotificationChannel(channelId)?.let {
                return it.importance > NotificationManager.IMPORTANCE_DEFAULT
            }
        }
        return notificationManager.importance > NotificationManager.IMPORTANCE_DEFAULT
    }
}